
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="solar_investment", lb=0)
    x2 = model.addVar(name="wind_investment", lb=0)

    # Objective function: maximize 0.06*x1 + 0.05*x2
    model.setObjective(0.06 * x1 + 0.05 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 50000, name="total_investment")
    model.addConstr(x2 >= 0.7 * 50000, name="wind_energy_constraint")
    model.addConstr(x1 <= 0.2 * 50000, name="solar_energy_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment in solar energy industry: ", x1.varValue)
        print("Optimal investment in wind energy industry: ", x2.varValue)
        print("Maximum return: ", model.objVal)
    else:
        print("The model is infeasible")

solve_investment_problem()
