
import gurobipy as gp

# Create a new model
m = gp.Model("jam_production")

# Create variables
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="strawberry_jam") # bottles of strawberry jam
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="peach_jam") # bottles of peach jam


# Set objective function
m.setObjective(3*x1 + 5*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 30*x2 <= 3500, "time_constraint")
m.addConstr(x1 <= 100, "strawberry_limit")
m.addConstr(x2 <= 80, "peach_limit")
m.addConstr(x1 >= 0, "strawberry_nonneg")
m.addConstr(x2 >= 0, "peach_nonneg")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Bottles of strawberry jam: {x1.x}")
    print(f"Bottles of peach jam: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

