
from gurobipy import *

# Create a new model
m = Model("Jam_Production")

# Add variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strawberry_jam")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peach_jam")

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 30*x2 <= 3500, "time_constraint")
m.addConstr(x1 <= 100, "strawberry_availability")
m.addConstr(x2 <= 80, "peach_availability")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Strawberry jam bottles: {x1.x}")
    print(f"Peach jam bottles: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
