
import gurobipy as gp

# Create a new model
m = gp.Model("Jam_Production")

# Define the variables
x1 = m.addVar(name="strawberry_jam", lb=0, ub=100, vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="peach_jam", lb=0, ub=80, vtype=gp.GRB.INTEGER)

# Objective function: Maximize 3*x1 + 5*x2
m.setObjective(3*x1 + 5*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(20*x1 + 30*x2 <= 3500, name="time_constraint")
m.addConstr(x1 <= 100, name="strawberry_limit")
m.addConstr(x2 <= 80, name="peach_limit")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Maximum profit: ${3*x1.varValue + 5*x2.varValue}")
else:
    print("No optimal solution found.")
