
import gurobipy as gp

# Create a new model
m = gp.Model("Street_Vendor")

# Create variables
fish = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fish") # number of fried fish
chicken = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chicken") # number of fried chicken

# Set objective function
m.setObjective(4 * fish + 5 * chicken, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * fish + 4 * chicken <= 400, "batter_constraint")
m.addConstr(5 * fish + 6 * chicken <= 500, "oil_constraint")
m.addConstr(fish >= 0, "fish_nonnegativity")
m.addConstr(chicken >= 0, "chicken_nonnegativity")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Revenue: ${m.objVal:.2f}")
    print(f"Number of Fried Fish: {fish.x:.2f}")
    print(f"Number of Fried Chicken: {chicken.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

