
from gurobipy import *

# Create a new model
m = Model("Fish_and_Chicken")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fried_fish")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fried_chicken")

# Set the objective function
m.setObjective(4*x1 + 5*x2, GRB.MAXIMIZE)

# Add the constraints
m.addConstr(3*x1 + 4*x2 <= 400, "batter_constraint")
m.addConstr(5*x1 + 6*x2 <= 500, "oil_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Fried Fish: {x1.x}")
    print(f"Fried Chicken: {x2.x}")
    print(f"Total Revenue: ${4*x1.x + 5*x2.x:.2f}")
else:
    print("No optimal solution found")
