
import gurobi

def solve_fried_food_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="fried_fish", lb=0)  # Number of fried fish
    x2 = model.addVar(name="fried_chicken", lb=0)  # Number of fried chicken

    # Define the objective function
    model.setObjective(4 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(3 * x1 + 4 * x2 <= 400, name="batter_constraint")
    model.addConstr(5 * x1 + 6 * x2 <= 500, name="oil_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of fried fish to sell: {x1.varValue}")
        print(f"Number of fried chicken to sell: {x2.varValue}")
        print(f"Maximum revenue: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_fried_food_problem()
