
import gurobipy as gp

# Create a new model
m = gp.Model("sandwich_optimization")

# Create variables
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="tuna_sandwiches") # Number of tuna salad sandwiches
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chicken_sandwiches") # Number of chicken salad sandwiches


# Set objective function
m.setObjective(2*x1 + 3*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 <= 300, "mixing_time")
m.addConstr(5*x1 + 6*x2 <= 400, "assembly_time")
m.addConstr(x1 >= 0, "tuna_nonnegative")
m.addConstr(x2 >= 0, "chicken_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of tuna salad sandwiches: {x1.x}")
    print(f"Number of chicken salad sandwiches: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

