
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="tuna_salad_sandwiches", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="chicken_salad_sandwiches", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: Maximize 2*x1 + 3*x2
    model.setObjective(2*x1 + 3*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x1 + 5*x2 <= 300, name="mixing_time_constraint")
    model.addConstr(5*x1 + 6*x2 <= 400, name="assembling_time_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: ${2*x1.varValue + 3*x2.varValue:.2f}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
