
import gurobipy as gp

# Create a new model
model = gp.Model("CakeToppingOptimization")

# Create variables
chocolate_toppings = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chocolate_toppings")
strawberry_toppings = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberry_toppings")


# Set objective function
model.setObjective(2 * chocolate_toppings + 3 * strawberry_toppings, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(chocolate_toppings <= 5, "MaxChocolate")
model.addConstr(1 * chocolate_toppings + 0.5 * strawberry_toppings >= 10, "MinSugar")
model.addConstr(2 * chocolate_toppings + 0.7 * strawberry_toppings >= 15, "MinButter")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal}")
    print(f"Chocolate Toppings: {chocolate_toppings.x}")
    print(f"Strawberry Toppings: {strawberry_toppings.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

