
from gurobipy import *

# Create a new model
m = Model("Northwest_Golden_Bakery")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chocolate_toppings")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strawberry_toppings")

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 <= 5, "max_chocolate")
m.addConstr(x1 + 0.5*x2 >= 10, "min_sugar")
m.addConstr(2*x1 + 0.7*x2 >= 15, "min_butter")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chocolate toppings: {x1.x}")
    print(f"Strawberry toppings: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
