
import gurobi

def solve_bakery_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="chocolate_toppings", lb=0, ub=5, vtype=gurobi.GRB.INTEGER)  # Number of chocolate toppings
    x2 = model.addVar(name="strawberry_toppings", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of strawberry toppings

    # Objective function: minimize cost
    model.setObjective(2*x1 + 3*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 <= 5, name="chocolate_limit")
    model.addConstr(x1 + 0.5*x2 >= 10, name="sugar_requirement")
    model.addConstr(2*x1 + 0.7*x2 >= 15, name="butter_requirement")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found")

solve_bakery_problem()
