
import gurobipy as gp

# Create a new model
model = gp.Model("LaundromatMix")

# Create variables
omega = model.addVar(vtype=gp.GRB.CONTINUOUS, name="omega")  # Cans from Omega
omini = model.addVar(vtype=gp.GRB.CONTINUOUS, name="omini")  # Cans from Omini

# Set objective function
model.setObjective(30 * omega + 40 * omini, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * omega + 5 * omini >= 30, "water")
model.addConstr(5 * omega + 6 * omini >= 35, "detergent")
model.addConstr(6 * omega + 5 * omini >= 40, "bleach")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Cans from Omega: {omega.x:.2f}")
    print(f"Cans from Omini: {omini.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

