
from gurobipy import *

# Create a new model
m = Model("Laundromat_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Omega_Cans")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Omini_Cans")

# Set the objective function
m.setObjective(30*x1 + 40*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 >= 30, "Water_Requirement")
m.addConstr(5*x1 + 6*x2 >= 35, "Detergent_Requirement")
m.addConstr(6*x1 + 5*x2 >= 40, "Bleach_Requirement")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of cans from Omega: {x1.x}")
    print(f"Number of cans from Omini: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found.")

