
import gurobi as gp

# Create a new model
m = gp.Model("Laundromat_Mixture")

# Define the variables
x1 = m.addVar(name="Omega_cans", lb=0, vtype=gp.GRB.INTEGER)  # cans from Omega
x2 = m.addVar(name="Omini_cans", lb=0, vtype=gp.GRB.INTEGER)  # cans from Omini

# Define the objective function
m.setObjective(30*x1 + 40*x2, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(3*x1 + 5*x2 >= 30, name="water_constraint")
m.addConstr(5*x1 + 6*x2 >= 35, name="detergent_constraint")
m.addConstr(6*x1 + 5*x2 >= 40, name="bleach_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Minimum cost: ${30*x1.x + 40*x2.x:.2f}")
else:
    print("No optimal solution found")
