
from gurobipy import Model, GRB

# Create a new model
m = Model("train_seating")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="first_class_seats")
x2 = m.addVar(vtype=GRB.INTEGER, name="second_class_seats")

# Set objective function
m.setObjective(75*x1 + 50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 500, "total_seats")
m.addConstr(x1 >= 100, "min_first_class")
m.addConstr(x2 >= 2*x1, "second_class_preference")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of first class seats: {x1.x}")
    print(f"Number of second class seats: {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

