
from gurobipy import *

# Create a new model
m = Model("Train_Seat_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="first_class_seats")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="second_class_seats")

# Set the objective function: Maximize profit
m.setObjective(75*x1 + 50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 500, "total_passengers")
m.addConstr(x1 >= 100, "first_class_minimum")
m.addConstr(x2 >= 2*x1, "second_class_preference")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"First-class seats: {x1.x}")
    print(f"Second-class seats: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
