
import gurobi as gp

# Create a new model
m = gp.Model("Train_Seats")

# Define variables
x1 = m.addVar(name="first_class_seats", lb=0, ub=500, vtype=gp.GRB.INTEGER)  # First-class seats
x2 = m.addVar(name="second_class_seats", lb=0, ub=500, vtype=gp.GRB.INTEGER)  # Second-class seats

# Objective function: Maximize profit
m.setObjective(75 * x1 + 50 * x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 500, name="total_passengers")  # Total passengers not exceeding 500
m.addConstr(x1 >= 100, name="first_class_min")  # At least 100 first-class seats
m.addConstr(x2 >= 2 * x1, name="second_class_pref")  # Second-class preference

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal first-class seats: {x1.varValue}")
    print(f"Optimal second-class seats: {x2.varValue}")
    print(f"Max Profit: ${75 * x1.varValue + 50 * x2.varValue}")
else:
    print("The model is infeasible.")
