
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Tropical_Farmer")

# Create variables
pineapples = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pineapples")  # Acres of pineapples
bananas = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")  # Acres of bananas


# Set objective function
m.setObjective(200 * pineapples + 150 * bananas, GRB.MAXIMIZE)

# Add constraints
m.addConstr(pineapples + bananas <= 200, "Land_Constraint")
m.addConstr(bananas <= 4 * pineapples, "Banana_Pineapple_Ratio")
m.addConstr(pineapples >= 40, "Min_Pineapples")
m.addConstr(bananas >= 60, "Min_Bananas")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Pineapples: {pineapples.x}")
    print(f"Acres of Bananas: {bananas.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

