
from gurobipy import *

# Create a new model
m = Model("Tropical_Farmer")

# Define variables
x1 = m.addVar(name="pineapples", vtype=GRB.CONTINUOUS, lb=40)
x2 = m.addVar(name="bananas", vtype=GRB.CONTINUOUS, lb=60)

# Set the objective function
m.setObjective(200*x1 + 150*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 200, name="total_land")
m.addConstr(x2 <= 4*x1, name="banana_limit")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pineapples: {x1.x}")
    print(f"Bananas: {x2.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
