
import gurobipy as gp

# Create a new model
m = gp.Model("TropicalFarmer")

# Define the variables
x1 = m.addVar(name="x1", lb=0)  # acres of pineapples
x2 = m.addVar(name="x2", lb=0)  # acres of bananas

# Objective function: Maximize 200*x1 + 150*x2
m.setObjective(200*x1 + 150*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 200, name="land_availability")
m.addConstr(x2 <= 4*x1, name="banana_to_pineapple_ratio")
m.addConstr(x1 >= 40, name="min_pineapples")
m.addConstr(x2 >= 60, name="min_bananas")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of pineapples: {x1.varValue}")
    print(f"Optimal acres of bananas: {x2.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("The model is infeasible")
