import os
from symb.Problem import Problem, convert_nlp4lp_to_Problem
from LLMServices.LLMService import LLMService
from LLMServices.VllamaLLMService import VllamaLLMService
from LLMServices.OllamaLLMService import OllamaLLMService
from LLMServices.VertexLLMService import VertexLLMService
import pickle
import json
import sys

def Baseline_LLM_Problem_Answer(problem: Problem, llm_service: LLMService,problem_name:str, llm_name:str, include_sym : bool = False):
    """
    Posts problem solution (and attributes) from team or generates a new one. You can feed this the instantiated team, your own problem,
    or nothing--in which case it will generate a new one.

    :param team: Team object
    :param target: team member to address
    :param problem: Problem object
    :param llm_service: LLMService object

    :returns: response containing problem solution and attributes.
    """
    prompt =f"""
    PURPOSE: I need you to solve an optimization problem, outputting gurobi code that captures the problem
    description and provides a solution, or otherwise indicates the problem is infeasible.
    CONTEXT: I need you to solve a linear programming optimization problem by properly converting the natural language description into a symbolic
    representation which you then translate into Gurobi code executed in python. 
    ROLE: You are a consulting team of business analysts, operations researchers, and programmers who will convert
    my natural language description of an optimization problem into functional gurobi code that answers my problem.
    INPUT: I need to solve the following problem: {problem.problem_statement}"""
    
    prompt+="OUTPUT:"
    if include_sym:
        prompt += f""" 
        In order to convince me that the code you are producing is correct, I also need to have a symbolic 
        representation of the problem showing me that you have converted the description above into an appropriate
        symbolic representation of the optimization problem. This consists of a pairs of variables in symbolic notation
        for the first item in the pair of the form 'x1', 'x2', and so on, and the second item of the pair being the 
        natural language object appearing in the problem description; the objective function rendered as an algebraic
        term where all natural language objects are substituted for the corresponding symbolic variable; and the
        list of semi-algebraic constraints where the natural language object is substituted with its 
        symbolic variable counterpart.
        
        Return this solution in a code bloc encased as ```json 
        {dict({"sym_variables":[("x#i","object#i")],
        "objective_function":"objective function description with sym variables",
        "constraints":["constraint",]})} 
        ```
        """
    prompt += f"""
    Finally, please output gurobi code enclosed as ```python \n <CODE>\n```.
    * Do not have anything else AFTER this final block.
    * If you provide any reasoning for your final answer, you MUST put it before the final ```python 
    <CODE>
    ``` 
    bloc
    """
    
    response = llm_service.do_prompt_get_text(prompt,name="Consultant")
    if include_sym:
        with open(os.path.join(os.getcwd(),'data','baseline_0shot_with_sym_nlp4lp',problem_name+"_"+llm_name+"_response.txt"), "w", encoding="utf-8") as outfile:
            outfile.write(response)
        sym_response = response.split('json')[-1]
        sym_response = sym_response.split('````')[0]
        with open(os.path.join(os.getcwd(),'data','baseline_0shot_with_sym_nlp4lp',problem_name+"_"+llm_name+"_solution.json"), 'w', encoding="utf-8") as f:
            json.dump(sym_response,f)
        code = response.split("python")[-1]
        code = code.split('```')[0]
        with open(os.path.join(os.getcwd(),'data', 'baseline_0shot_with_sym_nlp4lp',problem_name+"_"+llm_name+".py"),'w',encoding='utf-8') as f:
            f.write(code)
        with open(os.path.join(os.getcwd(),'data', 'baseline_0shot_with_sym_nlp4lp',problem_name+".pkl"), "wb") as file:
            pickle.dump(problem.to_dict(), file)
    else:
        with open(os.path.join(os.getcwd(),'data','baseline_0shot_nlp4lp',problem_name+"_"+llm_name+"_response.txt"), "w", encoding="utf-8") as outfile:
            outfile.write(response)
        code = response.split("python")[-1]
        code = code.split('```')[0]
        with open(os.path.join(os.getcwd(),'data', 'baseline_0shot_nlp4lp',problem_name+"_"+llm_name+".py"),'w',encoding='utf-8') as f:
            f.write(code)
        with open(os.path.join(os.getcwd(),'data', 'baseline_0shot_nlp4lp',problem_name+".pkl"), "wb") as file:
            pickle.dump(problem.to_dict(), file)

def main():
    
    if len(sys.argv) != 2:
        print("Usage: choose llm_name from : llama-3.3, llama-4, gemini")
    llm_name = sys.argv[1]
    if llm_name not in ['llama-3.3','llama-4','gemini']:
        llm_name = "llama-4"
    if llm_name == "llama-3.3":
        llm_service = OllamaLLMService()
    elif llm_name == "gemini":
        llm_service= VertexLLMService()
    else:
        llm_service = VllamaLLMService()
    #OllamaLLMService() #VllamaLLMSerivce
    
    path = os.path.join(os.getcwd(),'dataset','nlp4opt','generation_data')
    bad_dict = dict()
    data = []
    with open(os.path.join(path,'train.jsonl'), 'r', encoding='utf-8' ) as f:
        for line in f:
            data.append(json.loads(line))
    # nlp_dict = dict(data[0]).get(list(data[0].keys())[0])
    prob_names = []
    for n,item in enumerate(data):
        prob_names.append((n,list(item.keys())[0]))
    for prob_name in prob_names: # os.listdir(prob_dir):
        try:
            ld = data[prob_name[0]].get(prob_name[1])
            problem = convert_nlp4lp_to_Problem(ld)
            if prob_name[1]+"_"+llm_name+"_response.txt" not in os.listdir(os.path.join(os.getcwd(),'data','baseline_0shot_with_sym_nlp4lp')):
                Baseline_LLM_Problem_Answer(problem = problem, 
                                            llm_service = llm_service, 
                                            problem_name = prob_name[1], 
                                            llm_name=llm_name,
                                            include_sym = True)
            if prob_name[1]+"_"+llm_name+"_response.txt" not in os.listdir(os.path.join(os.getcwd(),'data','baseline_0shot_nlp4lp')):
                Baseline_LLM_Problem_Answer(problem = problem, 
                                            llm_service = llm_service, 
                                            problem_name = prob_name[1], 
                                            llm_name=llm_name)    
        except Exception as E:
            print(f"Ran into error: {E} for {prob_name}")
            bad_dict.__setitem__(prob_name[1],ld)
    with open(os.path.join(os.getcwd(),"bad_nlp4lp_"+llm_name+".pkl"), "wb") as file:
        pickle.dump(bad_dict, file)
        
if __name__ == "__main__":
    main()