import argparse
import os
from LLMServices.LLMService import LLMService
from LLMServices.VertexLLMService import VertexLLMService 
from LLMServices.OllamaLLMService import OllamaLLMService

from aci_model_eval import aci_model_eval

def main(llm="llama", model="aci", prob_dir=os.path.join(os.getcwd(),'data','oproblems')):
    print(f"LLM: {llm}")
    print(f"Model: {model}")
    print(f"Problem directory: {prob_dir}")

    if llm == 'gemini':
        llm_service_choice = VertexLLMService()
    else:
        llm_service_choice = OllamaLLMService()
    # Conditional function calls based on parameters
    if model == "aci":
        aci_model_eval(llm_service_choice = llm_service_choice, problem_dir = prob_dir)
    elif model == "coe":
        print("Cannot run CoE at this time!")

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Evaluate model on problem directory")
    parser.add_argument("--llm", default="llama", help="Language model to use")
    parser.add_argument("--model", default="aci", help="Model variant to use")
    parser.add_argument("--prob_dir", nargs="?", default=os.path.join(os.getcwd(),'data','oproblems'), help="Directory with problems")

    args = parser.parse_args()
    main(llm=args.llm, model=args.model, prob_dir=args.prob_dir)
