#!/bin/bash

# Define arrays of datasets and models
datasets=(
    # "celeba_hq"
    "afhq"
    # "cifar10"
    #"mnist"
    # "fashion_mnist"
)

models=(
    # "niedoba" # ✓
    "ours"  # ✓
    # "unet" # ✓
    # "optimal" # ✓
    # "wiener" # ✓
    # "kamb" # ✓
)

seeds=(
    42
    0
    1
    2
    3
    4
    5
    6
    7
)

masks=(
    0.005
    0.01
    0.02
    0.05
    0.07
    0.10
    0.15
)

# Loop through each dataset and model combination

for seed in "${seeds[@]}"; do
    for dataset in "${datasets[@]}"; do
        for model in "${models[@]}"; do
            for mask in "${masks[@]}"; do
                CUDA_VISIBLE_DEVICES=4 python analytic/ablation.py --dataset "$dataset" --model "$model" --seed "$seed" --mask_threshold "$mask"
            done
        done
    done
done
