import os
import os.path as osp

import numpy as np
from rekognition_online_action_detection.utils.parser import load_cfg


def main(args,phase="train"):
    args.new_data_root="data/THUMOS_10/class"
    args.data_root="data/THUMOS"
    num_frames=[]
    for i in range(0,22) :
        root=args.new_data_root+str(i)
        os.mkdir(root)
        num_frames.append([])
    save_dir="data/THUMOS_10/class"
    save_name=".npy"
    num_action_dir="data/THUMOS_10/num_action"
    result_dir="data/THUMOS_10"
    sessions = getattr(args.DATA, phase.upper() + '_SESSION_SET') 
    args.training = phase == 'train'
    num_videos = np.ones([22])
    videos = 0
    os.mkdir(num_action_dir)
    videos_actions_obj=np.zeros([200])
    for session in sessions:
        num_action=np.zeros([22])
        target = np.load(osp.join(args.data_root, 'target_perframe', session + '.npy')) 
        camera_inputs = np.load(
            osp.join(args.data_root, args.INPUT.VISUAL_FEATURE, session + '.npy'), mmap_mode='r') 
        motion_inputs = np.load(
            osp.join(args.data_root, args.INPUT.MOTION_FEATURE, session + '.npy'), mmap_mode='r') 
        
        height,width=target.shape
        exist_camera=[]
        exist_motion=[]
        for i in range(height) :
            truth=target[i].argmax()
            num_action[truth]=num_action[truth]+1
            if i==0 :  
                exist_camera.append(camera_inputs[i])
                exist_motion.append(motion_inputs[i])
            else:
                truth_previous = target[i - 1].argmax()  
                if truth==truth_previous:
                    exist_camera.append(camera_inputs[i])
                    exist_motion.append(motion_inputs[i])
                else:
                    num_frames[truth_previous].append(int(len(exist_motion)))
                    np.save(osp.join(save_dir+str(truth_previous),str(int(num_videos[int(truth_previous)]))+"_rgb"+save_name),exist_camera) 
                    exist_camera=[]
                    exist_camera.append(camera_inputs[i])
                    np.save(osp.join(save_dir + str(truth_previous), str(int(num_videos[int(truth_previous)])) + "_flow" + save_name),
                            exist_motion)
                    exist_motion=[]
                    exist_motion.append(motion_inputs[i])
                    num_videos[int(truth_previous)]=num_videos[int(truth_previous)]+1
        np.savetxt(osp.join(num_action_dir,str(videos)+".txt"),num_action,fmt="%d")
        videos_actions_obj[videos]=np.count_nonzero(num_action)
        videos=videos+1
    np.savetxt(osp.join(result_dir, "videos_actions_obj.txt"),videos_actions_obj,fmt="%d")
    for i in range(22):
        num_frames[i].append(int(len(num_frames[i])))
        np.savetxt(osp.join(save_dir+str(i),"class"+str(i)+"_frames_num.txt"),np.array(num_frames[i]),fmt="%d")  

if __name__ == '__main__':
        main(load_cfg())