


from rekognition_online_action_detection.utils.registry import Registry

TRAINERS = Registry()
INFERENCES = Registry()


def do_train(cfg,
             data_loaders,
             tet_data_loaders_i,
             model,
             criterion,
             optimizer,
             scheduler,
             device,
             checkpointer,
             logger,
             num_tasks,
             m,
             get_memory
             ):
    if get_memory==False:
        return TRAINERS[cfg.MODEL.MODEL_NAME](
            cfg,
            data_loaders,
            tet_data_loaders_i,
            model,
            criterion,
            optimizer,
            scheduler,
            device,
            checkpointer,
            logger,
            num_tasks,
            m,
            get_memory)
    else:
        exemplar_features, exemplar_set = TRAINERS[cfg.MODEL.MODEL_NAME](
            cfg,
            data_loaders,
            tet_data_loaders_i,
            model,
            criterion,
            optimizer,
            scheduler,
            device,
            checkpointer,
            logger,
            num_tasks,
            m,
            get_memory)
        return exemplar_features, exemplar_set


def do_inference(cfg,
            data_loaders_i,
            model,
            device,
            logger,num_task,
                 inferr):

        mean_AP=INFERENCES[cfg.MODEL.MODEL_NAME](
        cfg,
        data_loaders_i,
        model,
        device,
        logger,num_task,
        inferr)

        return mean_AP
