


import logging
logging.basicConfig(level=logging.INFO, format='%(message)s')
import argparse
import os.path as osp
import numpy as np
import pickle as pkl

from rekognition_online_action_detection.evaluation import compute_result


def eval_perframe(pred_scores_file,task):
    pred_scores_file=osp.join(pred_scores_file,'task_'+str(task)+'_best.pkl')
    pred_scores = pkl.load(open(pred_scores_file, 'rb'))
    cfg = pred_scores['cfg']
    perframe_gt_targets = pred_scores['perframe_gt_targets']
    perframe_pred_scores = pred_scores['perframe_pred_scores']

    
    result = compute_result['perframe'](
        cfg,
        np.concatenate(list(perframe_gt_targets.values()), axis=0),
        np.concatenate(list(perframe_pred_scores.values()), axis=0),
    )
    logging.info('task_'+str(task)+':Action detection perframe m{}: {:.5f}'.format(
        cfg.DATA.METRICS, result['mean_AP']
    ))


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--pred_scores_file', type=str, required=True)
    args = parser.parse_args()
    num_tasks=10
    for task in range(num_tasks):
        eval_perframe(args.pred_scores_file,task)
