


import time
from tqdm import tqdm
from rekognition_online_action_detection.utils.env import setup_environment
import torch
import torch.nn as nn
from rekognition_online_action_detection.models import build_model
from rekognition_online_action_detection.optimizers import build_optimizer
from rekognition_online_action_detection.evaluation import compute_result
from rekognition_online_action_detection.engines import do_inference
import os.path as osp
from rekognition_online_action_detection.utils.checkpointer import setup_checkpointer
from rekognition_online_action_detection.utils.icarl import icarl
from rekognition_online_action_detection.utils.utils import norm
import rekognition_online_action_detection.utils.utils as us
import numpy as np
import os




def do_perframe_det_train(cfg,
                          batch_size,
                          memory_video_ratio,
                          memory_frame_ratio,
                          data_loaders,
                          tet_dataloaders,
                          model,
                          criterion,
                          optimizer,
                          scheduler,
                          device,
                          checkpointer,
                          logger,
                          num_tasks,
                          m,
                          get_memory
                          ):
    video_memory=[]
    exemplar_index=[]
    videos=data_loaders['train'].dataset.video_data['task_'+str(num_tasks)]
    tet_checkpointer_root = 'checkpoints/THUMOS/LSTR/lstr_long_512_work_8_kinetics_1x'
    best_meanAP=0
    tet_model = build_model(cfg, device)
    tet_optimizer = build_optimizer(cfg, tet_model)
    tet_device = setup_environment(cfg)
    
    if torch.cuda.device_count() > 1:
        model = nn.DataParallel(model)
    if get_memory==False:
        for epoch in range(cfg.SOLVER.START_EPOCH, cfg.SOLVER.START_EPOCH + cfg.SOLVER.NUM_EPOCHS):
            
            det_losses = {phase: 0.0 for phase in cfg.SOLVER.PHASES}
            det_pred_scores = []
            det_gt_targets = []

            start = time.time()
            for phase in cfg.SOLVER.PHASES:
                training = phase == 'train'
                model.train(training)

                with torch.set_grad_enabled(training):
                    pbar = tqdm(data_loaders[phase],
                                desc='task{}:'.format(num_tasks)+'{}ing epoch {}'.format(phase.capitalize(), epoch))
                    for batch_idx, data in enumerate(pbar, start=1):
                        batch_size = data[0].shape[0]  
                        det_target = data[-1].to(device)

                        det_score = model(*[x.to(device) for x in data[:-1]])
                        det_score = det_score.reshape(-1, cfg.DATA.NUM_CLASSES) 
                        det_target = det_target.reshape(-1, cfg.DATA.NUM_CLASSES)
                        det_loss = criterion['MCE'](det_score, det_target)
                        det_losses[phase] += det_loss.item() * batch_size

                        
                        pbar.set_postfix({
                            'lr': '{:.7f}'.format(scheduler.get_last_lr()[0]),
                            'det_loss': '{:.5f}'.format(det_loss.item()),
                        })

                        if training:
                            optimizer.zero_grad()
                            det_loss.backward()
                            optimizer.step()
                            scheduler.step()
                        else:
                            
                            det_score = det_score.softmax(dim=1).cpu().tolist()
                            det_target = det_target.cpu().tolist()
                            det_pred_scores.extend(det_score)
                            det_gt_targets.extend(det_target)
            end = time.time()
            
            log = []
            log.append('Epoch {:2}'.format(epoch))
            log.append('train det_loss: {:.5f}'.format(
                det_losses['train'] / len(data_loaders['train'].dataset),
            ))
            if 'test' in cfg.SOLVER.PHASES:
                
                det_result = compute_result['perframe'](
                    cfg,
                    det_gt_targets,
                    det_pred_scores,
                )
                log.append('test det_loss: {:.5f} det_mAP: {:.5f}'.format(
                    det_losses['test'] / len(data_loaders['test'].dataset),
                    det_result['mean_AP'],
                ))
            log.append('running time: {:.2f} sec'.format(
                end - start,
            ))
            logger.info(' | '.join(log))
            
            if epoch == cfg.SOLVER.NUM_EPOCHS:
                checkpointer.save_best(epoch, model, optimizer, num_tasks)
            
            data_loaders['train'].dataset.shuffle()




    else:
        
        det_losses = {phase: 0.0 for phase in cfg.SOLVER.PHASES}
        task_all_scores=[]
        task_all_visual_features=[]
        task_all_flow_features = []
        task_all_target=[]
        task_all_index = []
        video_data=[]
        task_selected_features={}
        start = time.time()
        phase='test'
        training = phase == 'train'
        model.train(training)
        with torch.set_grad_enabled(training):
            pbar = tqdm(data_loaders['train'],
                        desc='task{}:'.format(num_tasks) + ': get memory')
            for batch_idx, data in enumerate(pbar, start=1):
                bs = data[0].shape[0]  
                det_target = data[-1].to(device)
                det_score = model(*[x.to(device) for x in data[:-1]])
                for i in range(bs):
                    video_memory.append(np.array(det_score[i].cpu().detach().numpy()).reshape(22*32))  
                    data_new=[]
                    data_new.append(data_loaders["train"].dataset.inputs[(batch_idx-1)*batch_size+i][0]) 
                    data_new.append(data[0][i])
                    data_new.append(data[1][i])
                    data_new.append(data[2][i])
                    data_new.append(data[3][i])
                    data_new.append(np.array(det_score[i].cpu().detach().numpy()))
                    video_data.append(data_new)
        video_now_name="new"
        video_num_batch = 0
        for i in range(len(video_data)):
            if video_now_name!=video_data[i][0]:    
                if video_now_name!="new":
                    video_num_batch=0  
                    task_all_scores.append(video_all_scores)
                    task_all_visual_features.append(video_all_visual_features)
                    task_all_flow_features.append(video_all_flow_features)
                    task_all_target.append(video_all_target)
                    task_all_index.append(video_all_index)
                video_now_name= video_data[i][0]
                video_all_scores = []
                video_all_visual_features=[]
                video_all_flow_features = []
                video_all_index = []
                video_all_target=[]
            for j in range(video_data[i][4].shape[0]):
                work_all_length=video_data[i][1].shape[0]
                work_target_length = video_data[i][4].shape[0]
                video_all_visual_features.append(np.array(video_data[i][1][j+work_all_length-work_target_length].cpu().detach().numpy()))
                video_all_flow_features.append(
                    np.array(video_data[i][2][j + work_all_length - work_target_length].cpu().detach().numpy()))
                video_all_target.append(np.array(video_data[i][4][j].cpu().detach().numpy()))
                video_all_scores.append(video_data[i][5][j])
                video_all_index.append(video_num_batch*video_data[i][4].shape[0]+j)
            video_num_batch =video_num_batch+1
        task_all_scores.append(video_all_scores)
        task_all_visual_features.append(video_all_visual_features)
        task_all_flow_features.append(video_all_flow_features)
        task_all_target.append(video_all_target)
        task_all_index.append(video_all_index)

        for i in range(len(task_all_scores)):
            video_all_scores=task_all_scores[i]  
            video_all_index = task_all_index[i]
            video_all_visual_features = task_all_visual_features[i]
            video_all_flow_features = task_all_flow_features[i]
            video_all_target=task_all_target[i]
            video_all_scores = np.array(video_all_scores)
            num_all_save=video_all_scores.shape[0]*memory_frame_ratio
            all_save_idx=icarl(video_all_scores,num_all_save,video_all_index) 
            all_visual_save=[]
            all_flow_save = []
            all_target_save=[]
            for j in range(len(all_save_idx)):
                all_visual_save.append(video_all_visual_features[all_save_idx[j]])
                all_flow_save.append(video_all_flow_features[all_save_idx[j]])
                all_target_save.append(video_all_target[all_save_idx[j]])
            selected_all_features=[]
            selected_all_features.append(all_visual_save)
            selected_all_features.append(all_flow_save)
            selected_all_features.append(all_target_save)
            task_selected_features[videos[i]]=selected_all_features
        return task_selected_features

