import numpy as np
import sys
def norm(data): 
    mean=np.mean(data,axis=0)
    std=np.std(data,axis=0)
    data_normalized=(data-mean)/std
    return data_normalized

def norm_mat(matrix): 
    mean = np.mean(matrix)  
    std = np.std(matrix)  
    normalized_matrix = (matrix - mean) / std  
    return normalized_matrix
def without_class_distance(vector1, vector2):   
    
    if len(vector1) != len(vector2):
        raise ValueError("Vector dimensions do not match.")
    
    diff = vector1 - vector2
    
    squared_diff = np.square(diff)
    
    distance = np.sqrt(np.sum(squared_diff))
    return distance

def within_class_distance(vector1, vector2):   
    
    if len(vector1) != len(vector2):
        raise ValueError("Vector dimensions do not match.")
    
    diff = vector1 - vector2
    
    squared_diff = np.square(diff)
    
    distance = np.sqrt(np.sum(squared_diff))
    if distance!=0:
        distance=1.0/distance
    return distance

def min_distance(distances, mst_set):
    min_dist = sys.maxsize
    min_index = -1
    for i in range(len(distances)):
        if distances[i] < min_dist and not mst_set[i]:
            min_dist = distances[i]
            min_index = i
    return min_index

def prim_algorithm(distances, num_back_points, num_action_points,num_back_selected,num_action_selected):
    mst = []
    num_points=num_action_points+num_back_points
    mst_set = [False] * num_points
    mst_set[0] = True
    selected_points = [0]
    selected_back_points=[0]
    selected_action_points=[]
    while len(selected_points) < num_action_selected+num_back_selected:
        min_dist = sys.maxsize
        min_index = -1
        for i in range(len(selected_points)):
            for j in range(num_points):
                if not mst_set[j] and distances[selected_points[i]][j] < min_dist and not (len(selected_back_points)>num_back_selected and j<num_back_points) and not (len(selected_action_points)>num_action_selected and j>num_back_points) : 
                    min_dist = distances[selected_points[i]][j]
                    min_index = j
        mst.append(min_dist)
        mst_set[min_index] = True
        selected_points.append(min_index)
        if min_index<num_back_points:
            selected_back_points.append(min_index)
        else:
            selected_action_points.append(min_index-num_back_points)

    return selected_back_points,selected_action_points


def sort_back_action(back,action,back_sample_num,action_sample_num,back_index,action_index):  
    back_num=back.shape[0]
    action_num=action.shape[0]
    video_back_back_distance=[]
    video_back_action_distance = []
    video_action_back_distance=[]
    video_action_action_distance = []
    for i in range(len(back)):  
        frame_back_back_distance=[]
        frame_back_action_distance = []
        for j in range(len(back)):
                frame_back_back_distance.append(within_class_distance(back[i], back[j]))
        video_back_back_distance.append(frame_back_back_distance)
        for j in range(len(action)):
                frame_back_action_distance.append(without_class_distance(back[i], action[j]))
        video_back_action_distance.append(frame_back_action_distance)
    for i in range(len(action)):  
        frame_action_action_distance = []
        frame_action_back_distance = []
        for j in range(len(action)):
                frame_action_action_distance.append(within_class_distance(action[i], action[j]))
        video_action_action_distance.append(frame_action_action_distance)
        for j in range(len(back)):
                frame_action_back_distance.append(without_class_distance(action[i], back[j]))
        video_action_back_distance.append(frame_action_back_distance)
    video_back_back_distance=norm_mat(np.array(video_back_back_distance))
    video_back_action_distance = norm_mat(np.array(video_back_action_distance))
    video_action_back_distance=norm_mat(np.array(video_action_back_distance))
    video_action_action_distance = norm_mat(np.array(video_action_action_distance))
    video_back_distance=np.concatenate((video_back_back_distance, video_back_action_distance), axis=1)
    video_action_distance = np.concatenate((video_action_back_distance, video_action_action_distance), axis=1)
    video_distance=np.concatenate((video_back_distance,  video_action_distance), axis=0)
    selected_back_points,selected_action_points=prim_algorithm(video_distance, len(back),len(action), int(back_sample_num),int(action_sample_num))
    selected_back_points_index=[]
    selected_action_points_index=[]
    for i in range(len(selected_back_points)):
        selected_back_points_index.append(back_index[selected_back_points[i]])
    for i in range(len(selected_action_points)):
        selected_action_points_index.append(action_index[selected_action_points[i]])
    seleted_index=selected_action_points_index+selected_back_points_index
    seleted_index=sorted(seleted_index)
    return seleted_index



