export N_USERS=2
export EVALUATION_MODEL="gpt-4-turbo"
export N_EXAMPLES=100
export N_EXAMPLES_MORE=100

#"claude-3-haiku" "claude-3-sonnet" "claude-3-opus")
#models=("mistral" "mixtral")
models=("mistral" "mixtral")
#reference_models=("claude-3-haiku" "claude-3-sonnet" "claude-3-opus")
reference_models=("claude-3-opus")
# Run the experiment

echo "Generating the disinformation first"
for model in ${models[@]}; do
    # First, generating the personalized tweets
    export CMD_STR="run_experiment.py --experiment_name personalized-tweet-disinfo --n_examples $N_EXAMPLES --model $model --n_users $N_USERS"
    echo $CMD_STR
    python $CMD_STR
done

echo "Next, generating the related tasks."
for model in ${models[@]}; do
    # Now generating the related tasks
    export CMD_STR="run_experiment.py --experiment_name generate-related-disinfo --n_examples $N_EXAMPLES --model $model --n_users $N_USERS"
    echo $CMD_STR
    python $CMD_STR
done

echo "Next, use a better model to solve the related tasks"
for model in ${models[@]}; do
    export CMD_STR="run_experiment.py --experiment_name personalized-tweet-disinfo --n_examples $N_EXAMPLES_MORE --model $model --output_model $model --n_users $N_USERS"
    echo $CMD_STR
    python $CMD_STR
    for reference_model in ${reference_models[@]}; do
        export CMD_STR="run_experiment.py --experiment_name personalized-tweet-disinfo --n_examples $N_EXAMPLES_MORE --model $reference_model --output_model $model --n_users $N_USERS"
        echo $CMD_STR
        python $CMD_STR
    done
done

echo "Finally, rerun on the original models with various added contexts"
for model in ${models[@]}; do
    # First, generating the nefarious scripts
    #reference_models=($model $REFERENCE_MODEL)
    export CMD_STR="run_experiment.py --model $model --reference_model $model --experiment_name personalized-tweet-disinfo --output_model $model --n_users $N_USERS --n_examples $N_EXAMPLES"
    echo $CMD_STR
    python $CMD_STR
    for reference_model in ${reference_models[@]}; do
        export CMD_STR="run_experiment.py --model $model --reference_model $model --experiment_name personalized-tweet-disinfo --output_model $reference_model --n_users $N_USERS --n_examples $N_EXAMPLES"
        echo $CMD_STR
        python $CMD_STR
    done
done

export EVALUATION_MODEL="gpt-4-turbo"
echo "Now, run the evaluation for everything"
#export REFERENCE_MODEL="claude-3-opus"
for model in ${models[@]}; do
    # First, doing this for single model
    export CMD_STR="run_experiment.py --experiment_name evaluate-disinformation --model $EVALUATION_MODEL --output_model $model  --n_users $N_USERS --n_examples $N_EXAMPLES"
    echo $CMD_STR
    python $CMD_STR
    # Next doing this for model evaluating itself
    export CMD_STR="run_experiment.py --experiment_name evaluate-disinformation --model $EVALUATION_MODEL --output_model $model --reference_model $model --n_users $N_USERS --n_examples $N_EXAMPLES"
    echo $CMD_STR
    python $CMD_STR
    for reference_model in ${reference_models[@]}; do
        export CMD_STR="run_experiment.py --experiment_name evaluate-disinformation --model $EVALUATION_MODEL --output_model $model --reference_model $reference_model --n_users $N_USERS --n_examples $N_EXAMPLES"
        echo $CMD_STR
        python $CMD_STR
    done
done

export N_USERS=1
export EVALUATION_MODEL="gpt-4-turbo"
export N_EXAMPLES=100
export N_EXAMPLES_MORE=100

#"claude-3-haiku" "claude-3-sonnet" "claude-3-opus")
#models=("mistral" "mixtral")
models=("mixtral")
#reference_models=("claude-3-haiku" "claude-3-sonnet" "claude-3-opus")
reference_models=("claude-3-opus")
# Run the experiment

echo "Generating the disinformation first"
for model in ${models[@]}; do
    # First, generating the personalized tweets
    export CMD_STR="run_experiment.py --experiment_name personalized-tweet-disinfo --n_examples $N_EXAMPLES --model $model --n_users $N_USERS"
    echo $CMD_STR
    python $CMD_STR
done

echo "Next, generating the related tasks."
for model in ${models[@]}; do
    # Now generating the related tasks
    export CMD_STR="run_experiment.py --experiment_name generate-related-disinfo --n_examples $N_EXAMPLES --model $model --n_users $N_USERS"
    echo $CMD_STR
    python $CMD_STR
done

echo "Next, use a better model to solve the related tasks"
for model in ${models[@]}; do
    export CMD_STR="run_experiment.py --experiment_name personalized-tweet-disinfo --n_examples $N_EXAMPLES_MORE --model $model --output_model $model --n_users $N_USERS"
    echo $CMD_STR
    python $CMD_STR
    for reference_model in ${reference_models[@]}; do
        export CMD_STR="run_experiment.py --experiment_name personalized-tweet-disinfo --n_examples $N_EXAMPLES_MORE --model $reference_model --output_model $model --n_users $N_USERS"
        echo $CMD_STR
        python $CMD_STR
    done
done

echo "Finally, rerun on the original models with various added contexts"
for model in ${models[@]}; do
    # First, generating the nefarious scripts
    #reference_models=($model $REFERENCE_MODEL)
    export CMD_STR="run_experiment.py --model $model --reference_model $model --experiment_name personalized-tweet-disinfo --output_model $model --n_users $N_USERS --n_examples $N_EXAMPLES"
    echo $CMD_STR
    python $CMD_STR
    for reference_model in ${reference_models[@]}; do
        export CMD_STR="run_experiment.py --model $model --reference_model $model --experiment_name personalized-tweet-disinfo --output_model $reference_model --n_users $N_USERS --n_examples $N_EXAMPLES"
        echo $CMD_STR
        python $CMD_STR
    done
done

export EVALUATION_MODEL="gpt-4-turbo"
echo "Now, run the evaluation for everything"
#export REFERENCE_MODEL="claude-3-opus"
for model in ${models[@]}; do
    # First, doing this for single model
    export CMD_STR="run_experiment.py --experiment_name evaluate-disinformation --model $EVALUATION_MODEL --output_model $model  --n_users $N_USERS --n_examples $N_EXAMPLES"
    echo $CMD_STR
    python $CMD_STR
    # Next doing this for model evaluating itself
    export CMD_STR="run_experiment.py --experiment_name evaluate-disinformation --model $EVALUATION_MODEL --output_model $model --reference_model $model --n_users $N_USERS --n_examples $N_EXAMPLES"
    echo $CMD_STR
    python $CMD_STR
    for reference_model in ${reference_models[@]}; do
        export CMD_STR="run_experiment.py --experiment_name evaluate-disinformation --model $EVALUATION_MODEL --output_model $model --reference_model $reference_model --n_users $N_USERS --n_examples $N_EXAMPLES"
        echo $CMD_STR
        python $CMD_STR
    done
done