models=("mistral" "mixtral")
echo "Generating the malicious scripts first"
models=("claude-3-haiku" "claude-3-sonnet" "claude-3-opus")
for model in ${models[@]}; do
    # First, generating the nefarious scripts
    export CMD_STR="run_experiment.py --experiment_name generate-python-script --model $model"
    echo $CMD_STR
    python $CMD_STR
done

echo "Next, generating the related tasks."
for model in ${models[@]}; do
    # First, generating the nefarious scripts
    export CMD_STR="run_experiment.py --model $model --experiment_name generate-related-tasks"
    echo $CMD_STR
    python $CMD_STR
done

echo "Next, use a better model to solve the related tasks"
export REFERENCE_MODEL="claude-3-sonnet"
models=("claude-3-haiku" "claude-3-sonnet" "claude-3-opus")
reference_models=("claude-3-haiku" "claude-3-sonnet" "claude-3-opus")
for model in ${models[@]}; do
    # First, generating the nefarious scripts
    #reference_models=($model $REFERENCE_MODEL)
    #reference_models=($REFERENCE_MODEL "claude-3-haiku")
    for reference_model in ${reference_models[@]}; do
        export CMD_STR="run_experiment.py --model $reference_model --experiment_name generate-python-script --output_model $model"
        echo $CMD_STR
        python $CMD_STR
    done
done

export REFERENCE_MODEL="claude-3-sonnet"
echo "Finally, rerun on the original models with the added context."
for model in ${models[@]}; do
    # First, generating the nefarious scripts
    #reference_models=($model $REFERENCE_MODEL)
    for reference_model in ${reference_models[@]}; do
        export CMD_STR="run_experiment.py --model $model --reference_model $model --experiment_name generate-python-script --output_model $reference_model"
        echo $CMD_STR
        python $CMD_STR
    done
done

export EVALUATION_MODEL="gpt-4-turbo"
echo "Now, run the evaluation"
#export REFERENCE_MODEL="claude-3-opus"
export REFERENCE_MODEL="claude-3-sonnet"
for model in ${models[@]}; do
    # First, doing this for single model
    export CMD_STR="run_experiment.py --model $EVALUATION_MODEL --output_model $model --experiment_name evaluate-hacking"
    echo $CMD_STR
    python $CMD_STR
    #reference_models=($model $REFERENCE_MODEL)
    for reference_model in ${reference_models[@]}; do
        export CMD_STR="run_experiment.py --model $EVALUATION_MODEL --output_model $model --experiment_name evaluate-hacking --reference_model $reference_model"
        echo $CMD_STR
        python $CMD_STR
    done
done