import os
import pickle
from datetime import datetime
import git
import json
import numpy as np

class DummyArgs:
    def __init__(self, **kwargs):
        self.__dict__.update(kwargs)

def get_text_data(file_type, base_dir = 'utils_data'):
    filename = None
    if file_type == 'activities':
        filename = 'activities'
    else:
        filename = file_type
    with open(f'{base_dir}/{filename}.txt', 'r') as f:
        data = f.readlines()
    celebrities = [d.strip().strip('\n') for d in data]
    return celebrities

def load_russian_bot_data():
    with open('data/russian-bot-tweets.pkl', 'rb') as f:
        data = pickle.load(f)
    return data

def get_activities():
    return get_text_data('activities')


def get_git_commit():
    repo = git.Repo(search_parent_directories=True)
    sha = repo.head.object.hexsha
    return sha

def all_args_match(current_args, old_args, ignore_args = ['sanity_check', 'git_sha']):
    #print('-'*20)
    #print(current_args)
    #print(old_args)
    for key in current_args:
        if key in ignore_args:
            continue
        if key not in old_args and current_args[key] is not None:
            return False
        # First, verify that they're the same type
        if current_args[key] is None and key not in old_args:
            continue
        if type(current_args[key]) != type(old_args[key]):
            return False
        if current_args[key] != old_args[key]:
            return False
    return True

def get_outdir_to_args(args):
    main_outdir = os.path.join(args.outdir, args.experiment_name)
    if not os.path.exists(main_outdir):
        return {}
    # Iterate through directories in the main outdir
    outdir_to_args = {}
    for subdir in os.listdir(main_outdir):
        subdir = os.path.join(main_outdir, subdir)
        if not os.path.isdir(subdir):
            continue
        args_filename = os.path.join(subdir, 'args.pkl')
        if not os.path.exists(args_filename):
            continue
        with open(args_filename, 'rb') as f:
            old_args = pickle.load(f)
        outdir_to_args[subdir] = old_args
    return outdir_to_args

def get_datetime_str(args, require_exists = False):
    args_dict = vars(args)
    outdir_to_old_args = get_outdir_to_args(args)
    match_count = 0 
    match_outdir = None
    for outdir, old_args in outdir_to_old_args.items():
        if all_args_match(args_dict, old_args):
            match_outdir = outdir
            match_count += 1
    if match_count == 0 and not require_exists:
        return datetime.now().strftime("%Y-%m-%d_%H-%M-%S-%f")
    elif match_count == 1:
        return os.path.basename(match_outdir)
    elif match_count == 0 and require_exists:
        print("Total options: ", len(outdir_to_old_args))
        print("Need to match: ", args_dict)
        for outdir, old_args in outdir_to_old_args.items():
            print("Not a match:")
            print(outdir)
            print(old_args)
        raise ValueError('No matches.')
    else:
        matches = []
        for outdir, old_args in outdir_to_old_args.items():
            if all_args_match(args_dict, old_args):
                print("Match:")
                print(outdir)
                matches.append(outdir)
                print(old_args)
        #most_recent = max([os.path.basename(outdir) for outdir in outdir_to_old_args.keys()])
        # THis is wrong, should do the most recent match
        most_recent = max([os.path.basename(match) for match in matches])
        print(f'Multiple matches: {match_count}, returning most recent: {most_recent}')
        return most_recent

def get_outdir(args, require_exists = False, force_outdir = None):
    if force_outdir is None:
        outdir = os.path.join(args.outdir, args.experiment_name, get_datetime_str(args, require_exists = require_exists))
    else:
        outdir = os.path.join(args.outdir, force_outdir, get_datetime_str(args, require_exists = require_exists))
    print(outdir, os.path.exists(outdir))
    if not os.path.exists(outdir) and not args.sanity_check:
        os.makedirs(outdir)
    return outdir

def load_from_saved(outdir, filetype):
    if filetype == 'results':
        filename = 'results.pkl'
    elif filetype == 'args':
        filename = 'args.pkl'
    elif filetype == 'log':
        filename = 'log/log.pkl'
    else:
        raise NotImplementedError
    with open(os.path.join(outdir, filename), 'rb') as f:
        data = pickle.load(f)
    return data