"""
This script checks the number of messages generated by the text generation in (create_itneventions.py)
Created by: Marc Brooks (MGB)
Date: 11/2024
Edit History: 5/21/2025 (MGB) - Changed the config file that this points to.

"""

import pandas as pd 
import numpy as np 

import os 
import sys 

import yaml

sys.path.append('.')
import utils


try:
    from yaml import CLoader as Loader
except ImportError:
    from yaml import Loader
    

date = '2024_12_30'
tones = ['actionability', 'authenticity', 'authoritativeness', 'conciseness',
         'emotiveness', 'formality', 'politeness']

with open('configs/simulation_setup_config.yaml', 'r') as f:
    sim_params = yaml.load(f, Loader=Loader)


n_messages = sim_params['text_sim']['n_messages'] 
sim_path = sim_params['text_sim']['sim_path'] 


for style in tones:
    df = pd.read_csv(f'{sim_path}/{date}/{style}_interventions_{n_messages}.csv')
    print(f'{style} has {df.shape[0]} messages')
    
    
