
# Environment

Please install conda environment based on ```pl.yml```.

Run ```conda env create -f pl.yml``` and follow instructions.

We use *wandb* and *tensorboard* to track training trajectory and metrics.

# Commands

To train PreResNet-32 with no data augmentaion, learning rate of ```0.8```, weight decay of ```0.0005``` and no momentum:

```python train_testing.py -c preresnet32_simple_no_aug_3000```

Checkpoints are saved under ```cifar-10/preresnet32_simple_no_aug_3000```.

To continue training one of the checkpoints with learning rate ```0.001``` (here we take checkpoints after 2 epochs as an example):

```python train_testing.py -c preresnet32_gf_no_aug_1e-3 --checkpoint cifar-10/preresnet32_simple_no_aug_3000/epoch=1-step=779.ckpt```

Other hyperparameter settings can be found in ```hparams/cifar10_hparams_dict_testing.py```.
