# Running DANCEST on CMAPSS Dataset

This README provides instructions for running the DANCEST (Dynamic Adaptive Neurosymbolic Causal Embeddings for Spatiotemporal) model on the NASA CMAPSS (Commercial Modular Aero-Propulsion System Simulation) dataset for jet engine degradation prediction.

## Directory Structure

The CMAPSS_DANCEST directory is organized as follows:

- **run_dancest_cmapss.py**: Main script for running the DANCEST pipeline without agents
- **run_dancest_cmapss_agents.py**: Script for running the full agent-based DANCEST architecture
- **run_cmapss_unified.bat**: Batch file for running the unified model (trained on all datasets)
- **run_cmapss_agents.bat**: Batch file for running the agent-based architecture
- **training/**: Contains symbolic model and training-related files
- **scripts/**: Utility scripts for data processing and analysis
- **DANCEST_model/**: Supporting DANCEST model files specific to CMAPSS

## Dataset Overview

The CMAPSS dataset consists of multiple run-to-failure simulations of turbofan engines under different operating conditions and failure modes:

- **FD001**: One operating condition, one failure mode
- **FD002**: Six operating conditions, one failure mode
- **FD003**: One operating condition, two failure modes
- **FD004**: Six operating conditions, two failure modes

## Prerequisites

- Python 3.7 or higher
- TensorFlow 2.x
- NetworkX
- NumPy
- Scikit-learn
- Pandas
- Matplotlib
- Scipy
- Joblib

## Setup

1. Ensure you are in the root directory of the repository:
```
cd DANCEST_model
```

2. Make sure all required directories exist:
```
if not exist logs mkdir logs
if not exist results mkdir results
if not exist models\saved mkdir models\saved
```
## Example Results

For CMAPSS FD001 dataset at cycle 100, the system predicts:
- Neural RUL: -0.87 ± 5.00
- Symbolic RUL: 25.55 ± 10.00
- Fusion weight: 0.67 (favoring neural prediction due to lower uncertainty)
- Fused RUL: 7.94 ± 3.33
- Final RUL after constraints: 7.74 ± 3.33 (adjusted by material-specific degradation rate of 0.95)



## Running DANCEST with Batch Files

### Using the Unified Model

To run the DANCEST model with the unified model (trained on all datasets):

```
CMAPSS_DANCEST\run_cmapss_unified.bat FD001 100
```

Where:
- `FD001` is the dataset ID (can be FD001, FD002, FD003, or FD004)
- `100` is the engine cycle number for prediction

### Using the Agent-Based Architecture

For more advanced analysis with the full agent-based DANCEST architecture:

```
CMAPSS_DANCEST\run_cmapss_agents.bat FD001 100
```

Where:
- `FD001` is the dataset ID (can be FD001, FD002, FD003, or FD004)
- `100` is the engine cycle number for prediction

You can also specify a custom model path as a third parameter:

```
CMAPSS_DANCEST\run_cmapss_agents.bat FD001 100 "models\saved\cmapss_unified_model_20250522_115949.keras"
```

## Running Directly with Python

You can also run the DANCEST model directly using Python:

### Standard Pipeline (Non-Agent)

```
python CMAPSS_DANCEST\run_dancest_cmapss.py --dataset FD001 --start_t 0 --end_t 250 --dt 50
```

Options:
- `--dataset`: Dataset ID (FD001, FD002, FD003, or FD004)
- `--start_t`: Starting time point (cycle)
- `--end_t`: Ending time point (cycle)
- `--dt`: Time step between predictions
- `--k`: Number of vertices in subgraph (default: 50)
- `--alpha`: Weight for causal relevance (default: 0.4)
- `--beta`: Weight for spatial relevance (default: 0.3)
- `--gamma`: Weight for temporal relevance (default: 0.3)

### Agent-Based Architecture

```
python CMAPSS_DANCEST\run_dancest_cmapss_agents.py --dataset1 FD001 --cycle 100 --debug
```

Options:
- `--dataset1`: Dataset ID (FD001, FD002, FD003, or FD004)
- `--cycle`: Engine cycle for prediction
- `--model_path`: Path to a specific neural model file (optional)
- `--use_unified`: Force use of unified model for any dataset
- `--debug`: Enable detailed debug logging
- `--use_newest`: Use the newest available trained model

## Output and Results

After running the DANCEST model, results are stored in:

- Prediction results: `results\`
- Logs: `logs\` and `agent_workflow.log`

The logs will contain details about:
- Neural model predictions
- Symbolic model predictions
- Fused predictions
- Agent communication (for agent-based architecture)
- Knowledge graph creation and subgraph extraction
- Physical constraint enforcement

## Evaluating Multiple Engines

To evaluate multiple engines or compare results across datasets:

```
REM Run for each dataset at cycle 100
CMAPSS_DANCEST\run_cmapss_agents.bat FD001 100
CMAPSS_DANCEST\run_cmapss_agents.bat FD002 100
CMAPSS_DANCEST\run_cmapss_agents.bat FD003 100
CMAPSS_DANCEST\run_cmapss_agents.bat FD004 100

REM Run for different cycles on the same dataset
CMAPSS_DANCEST\run_cmapss_agents.bat FD001 50
CMAPSS_DANCEST\run_cmapss_agents.bat FD001 100
CMAPSS_DANCEST\run_cmapss_agents.bat FD001 150
```

## Understanding the Results

The DANCEST model provides three types of predictions:

1. **Neural predictions**: Data-driven predictions from the neural network
2. **Symbolic predictions**: Physics-based predictions from the symbolic model
3. **Fused predictions**: Combined predictions using uncertainty-weighted fusion

The final RUL (Remaining Useful Life) prediction is the fused prediction, which balances between data-driven and physics-based approaches based on their respective uncertainties.

## Troubleshooting

- If you encounter a model not found error, check that the model path exists or use the `--use_newest` flag to automatically use the most recent model
- For detailed debugging, add the `--debug` flag to the Python command or check the log files
- If you get an error about missing modules, ensure you're running from the root directory of the repository
- If you see import errors related to the Core module, check that the directory structure is correct and the Core module is in the expected location 