@echo off
setlocal enabledelayedexpansion

echo ================================================================
echo DANCE-ST Agent-Based Architecture for CMAPSS Dataset
echo ================================================================
echo.

REM Create necessary directories
if not exist DANCEST_model\models\saved mkdir DANCEST_model\models\saved
if not exist DANCEST_model\results mkdir DANCEST_model\results
if not exist DANCEST_model\logs mkdir DANCEST_model\logs

REM Check if a dataset was specified
set DATASET=FD001
if not "%~1"=="" set DATASET=%~1

REM Check if a cycle was specified
set CYCLE=100
if not "%~2"=="" set CYCLE=%~2

REM Check if a specific model path was provided
set MODEL_PATH=
if not "%~3"=="" set MODEL_PATH=%~3

REM Set timestamp for log file
set "TIMESTAMP=%date:~-4,4%%date:~-10,2%%date:~-7,2%_%time:~0,2%%time:~3,2%%time:~6,2%"
set "TIMESTAMP=%TIMESTAMP: =0%"
set "LOG_FILE=DANCEST_model\logs\dancest_agents_%DATASET%_%TIMESTAMP%.log"

echo Running DANCE-ST agent pipeline for CMAPSS %DATASET% at cycle %CYCLE%
echo Full log will be saved to: %LOG_FILE%

REM Step 1: Set trained model path
echo.
echo Step 1: Using trained neural model...

if not "%~3"=="" (
  REM Use explicitly provided model path (unified model)
  set "MODEL_PATH=%~3"
  echo Using specified model: %MODEL_PATH%
) else (
  REM Try to find dataset-specific model
  set "MODEL_PATH=models\saved\cmapss_%DATASET%_model_20250522_110547.keras"
  if exist "%MODEL_PATH%" (
    echo Found trained model: %MODEL_PATH%
  ) else (
    echo Warning: Trained model not found at %MODEL_PATH%
    echo Will attempt to find another model or use fallback model.
  )
)

REM Step 2: Run the agent-based DANCE-ST pipeline
echo.
echo Step 2: Running agent-based DANCE-ST pipeline...
set PYTHONPATH=%PYTHONPATH%;%CD%
cd %~dp0
python run_dancest_cmapss_agents.py %DATASET% %CYCLE% "%MODEL_PATH%" --debug --use_unified > %LOG_FILE% 2>&1
cd %~dp0..\..\
if errorlevel 1 (
  echo Error in agent-based DANCE-ST pipeline. See %LOG_FILE% for details.
  exit /b 1
)

REM Extract DATA logs from the log file
echo.
echo ================================================================
echo                        AGENT COMMUNICATION
echo ================================================================
echo.
echo Extracting agent communication logs...

REM Create separate log files for each agent's communication
findstr /C:"[DATA]" %LOG_FILE% > DANCEST_model\logs\data_logs_%DATASET%_%TIMESTAMP%.txt
findstr /C:"knowledge graph" %LOG_FILE% > DANCEST_model\logs\kg_creation_%DATASET%_%TIMESTAMP%.txt
findstr /C:"KGMA" %LOG_FILE% > DANCEST_model\logs\kgma_logs_%DATASET%_%TIMESTAMP%.txt
findstr /C:"DMA" %LOG_FILE% > DANCEST_model\logs\dma_logs_%DATASET%_%TIMESTAMP%.txt
findstr /C:"SIA" %LOG_FILE% > DANCEST_model\logs\sia_logs_%DATASET%_%TIMESTAMP%.txt
findstr /C:"CEA" %LOG_FILE% > DANCEST_model\logs\cea_logs_%DATASET%_%TIMESTAMP%.txt
findstr /C:"DSA" %LOG_FILE% > DANCEST_model\logs\dsa_logs_%DATASET%_%TIMESTAMP%.txt

echo Data logs extracted to separate files in DANCEST_model\logs\

REM Display agent activities summary
echo.
echo ================================================================
echo                       PHASE 1: SUBGRAPH EXTRACTION
echo ================================================================
echo.
findstr /C:"INDEXED_VERTICES" %LOG_FILE%
findstr /C:"Causal importance scores" %LOG_FILE%
findstr /C:"Spatial relevance" %LOG_FILE%
findstr /C:"Temporal relevance" %LOG_FILE%
findstr /C:"Relevant subgraph extracted" %LOG_FILE%

echo.
echo ================================================================
echo                       PHASE 2: NEUROSYMBOLIC FUSION
echo ================================================================
echo.
findstr /C:"Neural predictions" %LOG_FILE%
findstr /C:"Symbolic predictions" %LOG_FILE%
findstr /C:"MATERIAL_PROPERTIES" %LOG_FILE%
findstr /C:"degradation rate" %LOG_FILE%
findstr /C:"Fusion complete" %LOG_FILE%
findstr /C:"Fusion weights" %LOG_FILE%

echo.
echo ================================================================
echo                       PHASE 3: CONSTRAINT ENFORCEMENT
echo ================================================================
echo.
findstr /C:"Constraints applied" %LOG_FILE%
findstr /C:"Constraint violations" %LOG_FILE%
findstr /C:"Physical constraints" %LOG_FILE%
findstr /C:"Final prediction" %LOG_FILE%

echo.
echo ================================================================
echo                DANCE-ST Agent Pipeline Complete
echo ================================================================
echo.
echo Detailed logs saved to: %LOG_FILE%
echo To view specific agent communications, check the log files in DANCEST_model\logs\

endlocal 