#!/usr/bin/env python3
"""
opt_weights.py — Newton–KL optimisation for relevance weights (α, β, γ)
------------------------------------------------------------------------
Solves the simplex‑constrained problem

    minimise   D_KL(p || w)   subject to   w ∈ Δ₂  (= {w ≥ 0, Σ w = 1})

where **p ∈ Δ₂** are the normalised aggregate relevance scores for the
causal, spatial, and temporal components output by Phase I of DANCE‑ST.

This is a wrapper around the implementation in DANCEST_model/Training/opt_weights.py
that allows importing directly from the root directory.
"""

# Import the main implementation from the Training directory
from DANCEST_model.Training.opt_weights import (
    newton_kl,
    optimize_for_phase1,
    _kl,
    _grad,
    _hessian,
    _project_simplex,
    projected_gd,
    run_quad_convergence_audit
)

# These are re-exported for compatibility
__all__ = [
    'newton_kl',
    'optimize_for_phase1',
    '_kl',
    '_grad',
    '_hessian',
    '_project_simplex',
    'projected_gd',
    'run_quad_convergence_audit'
] 