@echo off
setlocal enabledelayedexpansion

echo ================================================================
echo DANCE-ST for CMAPSS Dataset Pipeline
echo ================================================================
echo.

REM Create necessary directories
if not exist DANCEST_model\models\saved mkdir DANCEST_model\models\saved
if not exist DANCEST_model\models\tuning mkdir DANCEST_model\models\tuning
if not exist DANCEST_model\results mkdir DANCEST_model\results
if not exist DANCEST_model\data\cmapss_params mkdir DANCEST_model\data\cmapss_params

REM Check if a dataset was specified
set DATASET=FD001
if not "%~1"=="" set DATASET=%~1

echo Running DANCE-ST pipeline for CMAPSS %DATASET% dataset

REM Step 1: Train the neural model with hyperparameter tuning
echo.
echo Step 1: Training neural model with hyperparameter tuning...
python DANCEST_model/Training/train_dancest_neural_cmapss.py --dataset %DATASET%

REM Step 2: Run DANCEST pipeline for prediction
echo.
echo Step 2: Running DANCEST pipeline for prediction...
python DANCEST_model/run_dancest_cmapss.py --dataset %DATASET% --start_t 0 --end_t 200 --dt 50

echo.
echo ================================================================
echo DANCE-ST pipeline for CMAPSS %DATASET% complete!
echo Results are saved in:
echo   - DANCEST_model/models/saved/ (trained models)
echo   - DANCEST_model/results/ (predictions)
echo ================================================================
echo.

endlocal 