@echo off
echo CMAPSS Symbolic Model Runner
echo ===========================
echo.

REM Default arguments
set DATASET=FD001
set COMPONENT=hpc
set CYCLE=100
set MODE=single

REM Parse command-line arguments
if not "%1"=="" set DATASET=%1
if not "%2"=="" set COMPONENT=%2
if not "%3"=="" set CYCLE=%3
if not "%4"=="" set MODE=%4

echo Using dataset: %DATASET%
echo Component to analyze: %COMPONENT%
echo Cycle point: %CYCLE%
echo Mode: %MODE%
echo.
echo Using improved cross-validated neural model for prediction
echo.

REM Create results directory if it doesn't exist
if not exist results\symbolic_model mkdir results\symbolic_model

REM Run the symbolic model
python DANCEST_model/Core/cmapss_symbolic_model.py --dataset %DATASET% --component %COMPONENT% --cycle %CYCLE% --mode %MODE% --use_newest_model

echo.
echo Results saved to results/symbolic_model/
echo.

REM Optional: Run multiple datasets with a single command
if "%4"=="all" (
    echo.
    echo Running all datasets...
    echo.
    
    REM FD001 - Single operating condition, single failure mode
    python DANCEST_model/Core/cmapss_symbolic_model.py --dataset FD001 --component %COMPONENT% --cycle %CYCLE% --plot --output_dir results/symbolic_model
    
    REM FD002 - Multiple operating conditions, single failure mode
    python DANCEST_model/Core/cmapss_symbolic_model.py --dataset FD002 --component %COMPONENT% --cycle %CYCLE% --plot --output_dir results/symbolic_model
    
    REM FD003 - Single operating condition, multiple failure modes
    python DANCEST_model/Core/cmapss_symbolic_model.py --dataset FD003 --component %COMPONENT% --cycle %CYCLE% --plot --output_dir results/symbolic_model
    
    REM FD004 - Multiple operating conditions, multiple failure modes
    python DANCEST_model/Core/cmapss_symbolic_model.py --dataset FD004 --component %COMPONENT% --cycle %CYCLE% --plot --output_dir results/symbolic_model
    
    echo.
    echo All dataset results saved to results/symbolic_model/
) 