@echo off
REM Run the CMAPSS Symbolic Model test script
REM This will generate visualizations and validation data for the conference paper

echo Running CMAPSS Symbolic Model Test and Validation...

REM Create directories if they don't exist
if not exist "results" mkdir results
if not exist "results\symbolic_model_tests" mkdir results\symbolic_model_tests
if not exist "DANCEST_model\Testing" mkdir DANCEST_model\Testing

REM Run the test script
python DANCEST_model/Testing/test_cmapss_symbolic_model.py

echo.
echo Test complete. Results saved to results/symbolic_model_tests/
echo.
echo The following visualizations have been generated:
echo - Degradation progression curves
echo - RUL prediction curves for all datasets
echo - Operating condition effects
echo - Component interaction effects
echo - Paris law degradation behavior
echo - Dataset comparison analysis

echo.
echo These visualizations can be used directly in your conference paper.
echo A summary CSV file with dataset results is also available at results/symbolic_model_tests/dataset_summary.csv 