@echo off
echo CMAPSS Unified Neural Model Training with Cross-Validation
echo ========================================================
echo.

REM Default settings
set FOLDS=5
set VERBOSE=
set DATA_DIR=DANCEST_model\data\CMAPSSData

REM Parse command-line arguments
if not "%1"=="" set FOLDS=%1
if /i "%2"=="verbose" set VERBOSE=--verbose

echo Training unified neural model with %FOLDS%-fold cross-validation
echo Using data from: %DATA_DIR%
if defined VERBOSE echo Verbose output enabled
echo.

REM Create directories if they don't exist
if not exist "DANCEST_model\models\saved" mkdir DANCEST_model\models\saved
if not exist "DANCEST_model\results" mkdir DANCEST_model\results

echo This process may take a while...
echo.

REM Run the training script
python DANCEST_model/train_cmapss_unified.py --datasets FD001 FD002 FD003 FD004 --folds %FOLDS% %VERBOSE% --data_dir %DATA_DIR%

echo.
echo Training complete!
echo.
echo The best model has been saved to: DANCEST_model\models\saved\
echo Performance metrics have been saved to: DANCEST_model\results\
echo.
echo To use this model with the DANCEST framework, run:
echo     python DANCEST_model/run_dancest_cmapss_agents.py [dataset] [cycle] --use_newest
echo. 