"""Core module containing the fundamental DANCE-ST model components."""

from .pipeline import (
    DANCESTPipeline,
    ConstraintPotentialExtractor,
    UncertaintyWeightedFusion,
    ConstraintProjection,
)
from .agents import (
    AgentCoordinator,
    KnowledgeGraphManagementAgent,
    DataAgent,
    FusionAndProjectionAgent,
)
from .real_models import (
    NeuralEstimator,
    SymbolicEstimator,
)
from .dr_solver import project_onto_box_constraints

# Expose key classes for easy import
__all__ = [
    "DANCESTPipeline",
    "ConstraintPotentialExtractor",
    "UncertaintyWeightedFusion",
    "ConstraintProjection",
    "AgentCoordinator",
    "KnowledgeGraphManagementAgent",
    "DataAgent",
    "FusionAndProjectionAgent",
    "NeuralEstimator",
    "SymbolicEstimator",
    "project_onto_box_constraints",
]
