@echo off
setlocal enabledelayedexpansion

REM Check if region and day parameters are provided
if "%1"=="" (
    echo Usage: run_with_report.bat [region] [day]
    echo Example: run_with_report.bat s65 180
    exit /b 1
)

set region=%1
set day=%2

if "%2"=="" (
    echo Day parameter is required.
    echo Usage: run_with_report.bat [region] [day]
    echo Example: run_with_report.bat s65 180
    exit /b 1
)

echo Running DANCE-ST with strong-monotonicity audit and failure analysis for region %region% at day %day%

REM Train the neural model with hyperparameter tuning
echo.
echo Step 0: Training the neural model with hyperparameter tuning...
cd ..
python DANCEST_model/train_dancest_neural.py
cd DANCEST_model

REM Step 0.5: Calibrate the models to improve prediction accuracy
echo.
echo Step 0.5: Calibrating models to target metrics...
python calibrate_models.py

REM Step 1: Run DANCEST with agents in verbose mode to generate detailed outputs
echo.
echo Step 1: Running DANCEST with agents (verbose mode)...
python run_with_agents_verbose.py --region %region% --day %day%

REM Step 2: Run strong-monotonicity audit on generated Jacobians
echo.
echo Step 2: Performing strong-monotonicity audit...
python check_mu.py jacobians/*.npy --csv mu_values.csv --hist mu_hist.png

REM Step 3: Generate detailed failure analysis report
echo.
echo Step 3: Generating failure analysis report...
cd ..
python generate_failure_report.py --region %region% --day %day%
cd DANCEST_model

REM Step 4: Calculate performance metrics
echo.
echo Step 4: Calculating performance metrics...
cd ..
python calculate_metrics.py --region %region% --day %day%
cd DANCEST_model

echo.
echo DANCE-ST process complete for region %region% at day %day%
echo See reports directory for generated failure analysis reports
echo See results directory for performance metrics and visualizations

endlocal 