# DANCE-ST: Distributed Agent Network for Constraint-Enabled Spatiotemporal prediction

A comprehensive implementation of the DANCE-ST framework for spatiotemporal modeling of physical systems, with applications in predictive maintenance and degradation analysis. This code supports the findings of our ICLR 2026 paper, "DANCE-ST: Why Trustworthy AI Needs Constraint Guidance, Not Constraint Penalties."

> **Note**: Some implementation details, dataset specifics, and proprietary information have been redacted or anonymized for this submission.

## Supported Datasets

DANCE-ST has been validated on three primary datasets mentioned in the paper:

1.  **NASA C-MAPSS Dataset**: Turbofan engine degradation data for Remaining Useful Life (RUL) prediction.
    * **Documentation**: See `CMAPSS_DANCEST/README.md` for C-MAPSS-specific implementation details.
    * **Download**: The data can be downloaded from the [NASA PCoE Data Set Repository](https://www.nasa.gov/intelligent-systems-division/discovery-and-systems-health/pcoe/pcoe-data-set-repository/). Place it in `DANCEST_model/data/CMAPSSData`.
    * **Code**: `DANCEST_model/CMAPSS_DANCEST`

2.  **Turbine-500 Dataset**: A proprietary industrial dataset from an aerospace partner focused on turbine blade degradation.
    * **Location**: `data/T[ANONYMIZED]_lp_dataset/`
    * **Focus**: Predicting material degradation and thermal stress under various operating conditions.
    * **Note**: The full dataset has been anonymized and significantly reduced in size for the supplementary submission.

3.  **FEMTO Bearing Dataset**: Run-to-failure data for industrial bearings from the IEEE PHM 2012 Data Challenge.
    * **Download**: The data can be downloaded from the [NASA PCoE Data Set Repository](https://www.nasa.gov/intelligent-systems-division/discovery-and-systems-health/pcoe/pcoe-data-set-repository/) (listed as "Bearing Data Set").
    * **Note**: The core DANCE-ST framework can be adapted to it by constructing the appropriate knowledge graph and constraint set.

4.  **MIMIC-III Medical Dataset**: A large, de-identified critical care database.
    * **Download**: Access is managed through PhysioNet and requires credentialing. See the [MIMIC-III PhysioNet Project Page](https://physionet.org/content/mimiciii/1.4/) for instructions.
    * **Note**: Used for cross-domain validation. Access requires completion of a training course in human subjects research. 


## Table of Contents

1.  [Overview](#overview)
2.  [Key Features](#key-features)
3.  [Quick Start](#quick-start)
4.  [Architecture](#architecture)
5.  [Training Pipeline](#training-pipeline)
6.  [Theoretical Contributions](#theoretical-contributions)
7.  [File Structure](#file-structure)

## Overview

DANCE-ST treats physical constraints not as penalties, but as information sources to guide learning. This is achieved through three key phases:

1.  **Dynamic Relevance Selection via Constraint-Potential Diffusion**: Identifies critical system components in a training-free manner by propagating state-dependent "constraint potentials" through the system's knowledge graph.
2.  **Neurosymbolic Fusion with Uncertainty Quantification**: Intelligently combines neural and physics-based predictions based on their respective uncertainties.
3.  **Structure-Exploiting Constraint Projection**: Efficiently projects predictions onto the feasible space to guarantee they satisfy all physical laws.

The framework is orchestrated by six specialized agents that coordinate to deliver robust, physics-consistent predictions.

## Key Features

-   **Multi-Agent Architecture**: Six specialized agents coordinating for robustness and fault tolerance.
-   **Constraint-Guided Learning**: Uses physics as an active guide, not a post-hoc penalty.
-   **Neurosymbolic Fusion**: Uncertainty-weighted combination of neural and symbolic predictions.
-   **Hard Constraint Satisfaction**: Enforces domain-specific physical laws with mathematical guarantees.
-   **Uncertainty Quantification**: Provides confidence estimates for all predictions.
-   **Interpretable by Design**: Pinpoints which system components are driving constraint violations.

## Quick Start

### Prerequisites

```bash
pip install -r requirements.txt