@echo off
setlocal enabledelayedexpansion

echo ================================================================
echo DANCE-ST Neural and Symbolic Model Training with Calibration
echo ================================================================
echo.

REM Create necessary directories
if not exist models\saved mkdir models\saved
if not exist models\tuning mkdir models\tuning
if not exist results mkdir results

REM Step 1: Train the neural model with hyperparameter tuning
echo.
echo Step 1: Training neural model with hyperparameter tuning...
python train_dancest_neural.py

REM Step 2: Train and optimize the symbolic model
echo.
echo Step 2: Training and optimizing symbolic model...
python train_dancest_symbolic.py

REM Step 3: Calibrate both models together for optimal fusion
echo.
echo Step 3: Calibrating models for optimal fusion...
python calibrate_models.py

REM Step 4: Validate the combined models
echo.
echo Step 4: Validating combined models...
python evaluate_dancest_metrics.py

echo.
echo ================================================================
echo DANCE-ST model training complete!
echo Results are saved in:
echo   - models/saved/ (trained models)
echo   - results/ (calibration factors and visualizations)
echo ================================================================
echo.
echo Run tests with:
echo   run_with_report.bat [region] [day]
echo.

endlocal 