# References

We don't yet have a recommended BibTeX entry if you'd like to cite our work. If
you're using specific datasets, models, or baselines, see below.

## Datasets

### CIFAR-10 and CIFAR-100
```
@techreport{cifarKrizhevsky09learningmultiple,
  author = {Alex Krizhevsky},
  title = {Learning multiple layers of features from tiny images},
  institution = {University of Toronto},
  year = {2009}
}
```

### Civil Comments Toxicity Classification
```
@article{civil_comments,
  title     = {Nuanced Metrics for Measuring Unintended Bias with Real Data for Text
               Classification},
  author    = {Daniel Borkan and Lucas Dixon and Jeffrey Sorensen and Nithum Thain and Lucy Vasserman},
  journal   = {CoRR},
  volume    = {abs/1903.04561},
  year      = {2019},
  url       = {http://arxiv.org/abs/1903.04561},
  archivePrefix = {arXiv},
  eprint    = {1903.04561},
  timestamp = {Sun, 31 Mar 2019 19:01:24 +0200},
  biburl    = {https://dblp.org/rec/bib/journals/corr/abs-1903-04561},
  bibsource = {dblp computer science bibliography, https://dblp.org}
}
```

### Cityscapes
```
@inproceedings{Cordts2016Cityscapes,
  title     =  {The Cityscapes Dataset for Semantic Urban Scene Understanding},
  author    =  {Cordts, Marius and Omran, Mohamed and Ramos, Sebastian and Rehfeld, Timo and Enzweiler, Markus and Benenson, Rodrigo and Franke, Uwe and Roth, Stefan and Schiele, Bernt},
  booktitle =  {Proc. of the IEEE Conference on Computer Vision and Pattern Recognition (CVPR)},
  year      =  {2016}
}
```

### CLINC
```
@article{clinc,
  title = {An Evaluation Dataset for Intent Classification and Out-of-Scope Prediction},
  author = {Larson, Stefan and Mahendran, Anish and Peper, Joseph J and Clarke, Christopher and Lee, Andrew and Hill, Parker and Kummerfeld, Jonathan K and Leach, Kevin and Laurenzano, Michael A and Tang, Lingjia and others},
  journal = {arXiv preprint arXiv:1909.02027},
  year = {2019}
}
```

### Criteo
```
@article{criteo,
  title = {Display Advertising Challenge},
  url = {https://www.kaggle.com/c/criteo-display-ad-challenge.},
}
```

### GLUE
```
@inproceedings{glue,
  title = "{GLUE}: A Multi-Task Benchmark and Analysis Platform for Natural Language Understanding",
  author = "Wang, Alex  and
    Singh, Amanpreet  and
    Michael, Julian  and
    Hill, Felix  and
    Levy, Omer  and
    Bowman, Samuel",
  booktitle = "Proceedings of the 2018 {EMNLP} Workshop {B}lackbox{NLP}: Analyzing and Interpreting Neural Networks for {NLP}",
  month = nov,
  year = "2018",
  address = "Brussels, Belgium",
  publisher = "Association for Computational Linguistics",
  url = "https://www.aclweb.org/anthology/W18-5446",
  doi = "10.18653/v1/W18-5446",
  pages = "353--355"
}
```

### ImageNet
```
@article{imagenet,
  Author = {Olga Russakovsky and Jia Deng and Hao Su and Jonathan Krause and Sanjeev Satheesh and Sean Ma and Zhiheng Huang and Andrej Karpathy and Aditya Khosla and Michael Bernstein and Alexander C. Berg and Li Fei-Fei},
  Title = {{ImageNet Large Scale Visual Recognition Challenge}},
  Year = {2015},
  journal = {International Journal of Computer Vision (IJCV)},
  volume = {115},
  number = {3},
  pages = {211-252}
}
```

### MNIST
```
@article{mnist,
  author = {LeCun, Yann and Cortes, Corinna},
  title = {{MNIST} handwritten digit database},
  url = {http://yann.lecun.com/exdb/mnist/},
  year = 2010
}
```

### MNLI
```
@InProceedings{N18-1101,
  author = "Williams, Adina
            and Nangia, Nikita
            and Bowman, Samuel",
  title = "A Broad-Coverage Challenge Corpus for
           Sentence Understanding through Inference",
  booktitle = "Proceedings of the 2018 Conference of
               the North American Chapter of the
               Association for Computational Linguistics:
               Human Language Technologies, Volume 1 (Long
               Papers)",
  year = "2018",
  publisher = "Association for Computational Linguistics",
  pages = "1112--1122",
  location = "New Orleans, Louisiana",
  url = "http://aclweb.org/anthology/N18-1101"
}
```

### UCI
```
@misc{UCI,
  author = "Dua, Dheeru and Graff, Casey",
  year = "2017",
  title = "{UCI} Machine Learning Repository",
  url = "http://archive.ics.uci.edu/ml",
  institution = "University of California, Irvine, School of Information and Computer Sciences"
}
```

### Wikipedia Talk Toxicity Classification
```
@inproceedings{wikipedia_talk,
  author = {Wulczyn, Ellery and Thain, Nithum and Dixon, Lucas},
  title = {Ex Machina: Personal Attacks Seen at Scale},
  year = {2017},
  isbn = {9781450349130},
  publisher = {International World Wide Web Conferences Steering Committee},
  address = {Republic and Canton of Geneva, CHE},
  url = {https://doi.org/10.1145/3038912.3052591},
  doi = {10.1145/3038912.3052591},
  booktitle = {Proceedings of the 26th International Conference on World Wide Web},
  pages = {1391-1399},
  numpages = {9},
  keywords = {online discussions, wikipedia, online harassment},
  location = {Perth, Australia},
  series = {WWW '17}
}
```

## Models

### Residual Networks
```
@misc{resnet,
  title={Deep residual learning for image recognition. CoRR abs/1512.03385 (2015)},
  author={He, Kaiming and Zhang, Xiangyu and Ren, Shaoqing and Sun, Jian},
  year={2015}
}
```

### Criteo MLP
```
@inproceedings{uncertaintybenchmark,
  title={Can you trust your model's uncertainty? Evaluating predictive uncertainty under dataset shift},
  author={Snoek, Jasper and Ovadia, Yaniv and Fertig, Emily and Lakshminarayanan, Balaji and Nowozin, Sebastian and Sculley, D and Dillon, Joshua and Ren, Jie and Nado, Zachary},
  booktitle={Advances in Neural Information Processing Systems},
  pages={13969--13980},
  year={2019}
}
```

### Text CNN
```
@inproceedings{textcnn,
  title = "Convolutional Neural Networks for Sentence Classification",
  author = "Kim, Yoon",
  booktitle = "Proceedings of the 2014 Conference on Empirical Methods in Natural Language Processing ({EMNLP})",
  month = oct,
  year = "2014",
  address = "Doha, Qatar",
  publisher = "Association for Computational Linguistics",
  url = "https://www.aclweb.org/anthology/D14-1181",
  doi = "10.3115/v1/D14-1181",
  pages = "1746--1751",
}
```

### UNET
```
@inproceedings{ronneberger2015u,
  title={U-net: Convolutional networks for biomedical image segmentation},
  author={Ronneberger, Olaf and Fischer, Philipp and Brox, Thomas},
  booktitle={International Conference on Medical image computing and computer-assisted intervention},
  pages={234--241},
  year={2015},
  organization={Springer}
}
```

### BERT
```
@inproceedings{bert,
  title = "{BERT}: Pre-training of Deep Bidirectional Transformers for Language Understanding",
  author = "Devlin, Jacob  and
    Chang, Ming-Wei  and
    Lee, Kenton  and
    Toutanova, Kristina",
  booktitle = "Proceedings of the 2019 Conference of the North {A}merican Chapter of the Association for Computational Linguistics: Human Language Technologies, Volume 1 (Long and Short Papers)",
  month = jun,
  year = "2019",
  address = "Minneapolis, Minnesota",
  publisher = "Association for Computational Linguistics",
  url = "https://www.aclweb.org/anthology/N19-1423",
  doi = "10.18653/v1/N19-1423",
  pages = "4171--4186",
}
```

### Wide ResNet-*-*
```
@article{zagoruyko2016wide,
  title={Wide residual networks},
  author={Zagoruyko, Sergey and Komodakis, Nikos},
  journal={arXiv preprint arXiv:1605.07146},
  year={2016}
}
```

## Methods

### BatchEnsemble
```
@article{wen2020batchensemble,
  title={Batchensemble: an alternative approach to efficient ensemble and lifelong learning},
  author={Wen, Yeming and Tran, Dustin and Ba, Jimmy},
  journal={arXiv preprint arXiv:2002.06715},
  year={2020}
}
```

### Deep Ensembles
```
@article{lakshminarayanan2016simple,
  title={Simple and scalable predictive uncertainty estimation using deep ensembles},
  author={Lakshminarayanan, Balaji and Pritzel, Alexander and Blundell, Charles},
  journal={arXiv preprint arXiv:1612.01474},
  year={2016}
}
```

### Focal Loss
```
@article{mukhoti2019intriguing,
  title={The Intriguing Effects of Focal Loss on the Calibration of Deep Neural Networks},
  author={Mukhoti, Jishnu and Kulharia, Viveka and Sanyal, Amartya and Golodetz, Stuart and Torr, Philip and Dokania, Puneet},
  year={2019}
}
```

### Heteroscedastic
```
@inproceedings{collier2021heteroscedastic,
  title={Correlated Input-Dependent Label Noise in Large-Scale Image Classification},
  author={Collier, Mark and Mustafa, Basil and Kokiopoulou, Efi and Jenatton, Rodolphe and Berent, Jesse},
  booktitle={Proceedings of the IEEE Conference on Computer Vision and Pattern Recognition},
  year={2021}
}
```

### Hyper-Ensemble, Hyper-BatchEnsemble
```
@article{wenzel2020hyperparameter,
  title={Hyperparameter ensembles for robustness and uncertainty quantification},
  author={Wenzel, Florian and Snoek, Jasper and Tran, Dustin and Jenatton, Rodolphe},
  journal={arXiv preprint arXiv:2006.13570},
  year={2020}
}
```

### MIMO
```
@article{havasi2020training,
  title={Training independent subnetworks for robust prediction},
  author={Havasi, Marton and Jenatton, Rodolphe and Fort, Stanislav and Liu, Jeremiah Zhe and Snoek, Jasper and Lakshminarayanan, Balaji and Dai, Andrew M and Tran, Dustin},
  journal={arXiv preprint arXiv:2010.06610},
  year={2020}
}
```

### MixUp
```
@article{carratino2020mixup,
  title={On mixup regularization},
  author={Carratino, Luigi and Ciss{\'e}, Moustapha and Jenatton, Rodolphe and Vert, Jean-Philippe},
  journal={arXiv preprint arXiv:2006.06049},
  year={2020}
}
```

### Monte-Carlo Dropout
```
@inproceedings{gal2016dropout,
  title={Dropout as a bayesian approximation: Representing model uncertainty in deep learning},
  author={Gal, Yarin and Ghahramani, Zoubin},
  booktitle={international conference on machine learning},
  pages={1050--1059},
  year={2016},
  organization={PMLR}
}
```

### Radial Bayesian Neural Networks
```
@inproceedings{farquhar2020radial,
  title={Radial bayesian neural networks: Beyond discrete support in large-scale bayesian deep learning},
  author={Farquhar, Sebastian and Osborne, Michael A and Gal, Yarin},
  booktitle={International Conference on Artificial Intelligence and Statistics},
  pages={1352--1362},
  year={2020},
  organization={PMLR}
}
```

### Rank-1 BNNs
```
@inproceedings{dusenberry2020efficient,
  title={Efficient and scalable bayesian neural nets with rank-1 factors},
  author={Dusenberry, Michael and Jerfel, Ghassen and Wen, Yeming and Ma, Yian and Snoek, Jasper and Heller, Katherine and Lakshminarayanan, Balaji and Tran, Dustin},
  booktitle={International conference on machine learning},
  pages={2782--2792},
  year={2020},
  organization={PMLR}
}
```

### SNGP
```
@article{liu2020simple,
  title={Simple and principled uncertainty estimation with deterministic deep learning via distance awareness},
  author={Liu, Jeremiah Zhe and Lin, Zi and Padhy, Shreyas and Tran, Dustin and Bedrax-Weiss, Tania and Lakshminarayanan, Balaji},
  journal={arXiv preprint arXiv:2006.10108},
  year={2020}
}
```

### Variational Inference
```
@inproceedings{blundell2015weight,
  title={Weight uncertainty in neural network},
  author={Blundell, Charles and Cornebise, Julien and Kavukcuoglu, Koray and Wierstra, Daan},
  booktitle={International Conference on Machine Learning},
  pages={1613--1622},
  year={2015},
  organization={PMLR}
}
```
