

# Adaptational Analysis Fine-Tuning

This repository contains the complete set of Python scripts required to reproduce the adaptational analysis experiments presented in the paper. The workflow is designed as a three-stage pipeline:

1.  **Component Sweep:** A broad fine-tuning run across all layers to identify which components (MLP vs. Attention) are most affected by domain adaptation.
2.  **Scout & Architect:** An analysis script that processes the results from Stage 1 to identify the most impactful layers and automatically generates configuration files for targeted experiments.
3.  **Targeted Fine-Tuning:** A final fine-tuning run that executes the specific, parameter-efficient configurations generated in Stage 2.

This methodology allows for a systematic, data-driven approach to identifying the loci of domain specialization.

-----

## Table of Contents

1.  [Repository Structure](#repository-structure)
2.  [Setup and Installation](#setup-and-installation)
3.  [Reproduction Workflow](#reproduction-workflow)

-----

## Repository Structure

The repository is organized to reflect the sequential nature of the experiments.

```bash
.
├── data/
│   ├── cpp.json
│   ├── python.json
│   ├── finance.json
│   ├── medical.json
│   ├── math.json
│   └── science.json
│
├── output/
│   ├── stage_1_sweep_results/    # Raw outputs from the initial component-wise sweep.
│   ├── stage_2_generated_configs/ # Auto-generated Python configs from the scout script.
│   └── stage_3_targeted_results/ # Final results from the targeted fine-tuning runs.
│
├── 01_component_sweep.py         # Stage 1: Runs broad fine-tuning on MLP, Attention, or both.
├── 02_scout_and_architect.py     # Stage 2: Analyzes Stage 1 results and creates experiment configs.
├── 03_targeted_finetune.py       # Stage 3: Runs targeted, layer-specific fine-tuning experiments.
│
├── README.md                     # This documentation file.
└── requirements.txt              # A list of all required Python packages.
```

-----

## Setup and Installation

### 1\. Prerequisites

  * Python 3.10+
  * `pip` and `venv`

### 2\. Environment Setup

First, create and activate a virtual environment to manage dependencies.

  * On Linux:
    ```bash
    python3 -m venv venv
    source venv/bin/activate
    ```

### 3\. Install Dependencies

Install all required packages using the `requirements.txt` file.

```bash
pip install -r requirements.txt
```

### 4\. Hugging Face Authentication

The scripts require access to gated models like Llama 3.2. You must authenticate with the Hugging Face Hub. Run the following command in your terminal and enter an access token with read permissions.

```bash
huggingface-cli login
```

-----

## Reproduction Workflow



### Stage 1: Broad Component-wise Sweep

This script performs the initial, comprehensive fine-tuning run. For each domain dataset, it trains three model variants: one with LoRA adapters on **MLP layers only**, one on **Attention layers only**, and one on **both**.

  * **What it produces:** A structured directory in `output/stage_1_sweep_results/` containing the raw adapter tensors and CSV files with the Frobenius norm of the weight changes for every layer and every run.

### Stage 2: Scout and Architect

This script acts as an automated analyst. It ingests the norm data from Stage 1, identifies the top-performing layers (e.g., top-k individual layers, top consecutive blocks), and generates Python configuration files for the next stage.

  * **What it produces:** A set of `_experiments.py` files in `output/stage_2_generated_configs/`. Each file contains a dictionary defining the specific layer-component combinations to be trained in the final stage.

### Stage 3: Targeted Fine-Tuning

This final script reads the configurations generated by the scout and executes a series of highly targeted, LDC-informed fine-tuning experiments. This includes runs on single top-performing layers, ensembles of top layers, and theorized "circuit-based" combinations.


  * **What it produces:** The final experimental results in `output/stage_3_targeted_results/`, including weight-change norms and evaluation loss curves for each targeted configuration. This data is used to generate the final tables and figures for the paper.