"""
obfuscation_prompt_builder.py

Applies simple obfuscation (e.g., entity masking or paraphrasing) to premise-hypothesis pairs.
"""

import re
import random

ENTITY_MASKS = {
    "8 million": "{NUM}",
    "emergency housing": "{LOCATION}",
    "New York": "{LOCATION}",
    "John": "{PERSON}",
}

def obfuscate_sentence(sentence):
    """
    Replaces entities in a sentence with predefined placeholders.

    Args:
        sentence (str): Raw input sentence.

    Returns:
        str: Obfuscated sentence.
    """
    for k, v in ENTITY_MASKS.items():
        sentence = re.sub(re.escape(k), v, sentence, flags=re.IGNORECASE)
    return sentence

def build_obfuscated_prompt(premise, hypothesis):
    """
    Obfuscates premise and hypothesis and returns them as a tuple.

    Args:
        premise (str): The original premise.
        hypothesis (str): The original hypothesis.

    Returns:
        tuple: (obfuscated_premise, obfuscated_hypothesis)
    """
    return obfuscate_sentence(premise), obfuscate_sentence(hypothesis)

# Example usage
if __name__ == "__main__":
    p = "8 million in relief in the form of emergency housing."
    h = "The 8 million dollars for emergency housing was still not enough to solve the problem."
    print(build_obfuscated_prompt(p, h))
