"""
template_prompt_builder.py

Constructs template-guided prompts from raw text inputs (e.g., premise and hypothesis).
"""

import random

TEMPLATES = [
    "Based on the premise: {premise}, does the hypothesis: {hypothesis} logically follow?",
    "Given: {premise}, can we infer that: {hypothesis}?",
    "Does the statement: {hypothesis} logically follow from: {premise}?"
]

def build_template_prompt(premise, hypothesis):
    """
    Randomly selects a template and inserts the premise and hypothesis.

    Args:
        premise (str): The input premise sentence.
        hypothesis (str): The input hypothesis sentence.

    Returns:
        str: A generated natural language prompt.
    """
    template = random.choice(TEMPLATES)
    return template.format(premise=premise, hypothesis=hypothesis)

# Example usage
if __name__ == "__main__":
    p = "A person is positioned near a podium."
    h = "He is preparing to talk."
    print(build_template_prompt(p, h))
