import numpy as np
from sklearn.metrics import accuracy_score, f1_score, precision_score, recall_score

class Metrics:
    def __init__(self):
        self.targets = []
        self.preds = []

    def update(self, predictions, labels):
        self.preds.extend(predictions)
        self.targets.extend(labels)

    def compute(self):
        accuracy = accuracy_score(self.targets, self.preds)
        precision = precision_score(self.targets, self.preds, average='weighted', zero_division=0)
        recall = recall_score(self.targets, self.preds, average='weighted', zero_division=0)
        f1 = f1_score(self.targets, self.preds, average='weighted', zero_division=0)
        return {
            "accuracy": accuracy,
            "precision": precision,
            "recall": recall,
            "f1": f1
        }

    def reset(self):
        self.targets = []
        self.preds = []
